﻿package away3d.materials.shaders
{
	import away3d.containers.*;
	import away3d.arcane;
	import away3d.core.base.*;
	import away3d.core.draw.*;
	import away3d.core.render.*;
	
	import flash.display.*;
	
	use namespace arcane;
	
	/**
	 * Shader class for ambient lighting
	 * 
	 * @see away3d.lights.AmbientLight3D
	 */
    public class AmbientShader extends AbstractShader
    {
        /**
        * Defines a 24 bit color value used by the shader
        */
        public var color:uint;
    	
		/**
		 * Creates a new <code>AmbientShader</code> object.
		 * 
		 * @param	init	[optional]	An initialisation object for specifying default instance properties.
		 */
        public function AmbientShader(init:Object = null)
        {
        	super(init);
        }
        
		/**
		 * @inheritDoc
		 */
		public override function updateMaterial(source:Object3D, view:View3D):void
        {
        	clearLightingShapeDictionary();
        }
        
		/**
		 * @inheritDoc
		 */
        protected override function clearFaceDictionary(source:Object3D, view:View3D):void
        {
        	notifyMaterialUpdate();
        	
        	for each (_faceVO in _faceDictionary) {
        		if (source == _faceVO.source) {
	        		if (!_faceVO.cleared)
	        			_faceVO.clear();
	        		_faceVO.invalidated = true;
	        	}
        	}
        }
        
		/**
		 * @inheritDoc
		 */
        public override function renderLayer(tri:DrawTriangle, layer:Sprite, level:int):void
        {
        	super.renderLayer(tri, layer, level);
    		
        	for each (ambient in tri.source.lightarray.ambients)
        	{
        		if (_lights.numLights > 1) {
					_shape = getLightingShape(layer, ambient);
		        	_shape.blendMode = blendMode;
		        	_graphics = _shape.graphics;
		        } else {
		        	_graphics = layer.graphics;
		        }
	        	
				_source.session.renderTriangleBitmap(ambient.ambientBitmap, _mapping, tri.v0, tri.v1, tri.v2, smooth, false, _graphics);
        	}
			
			if (debug)
                tri.source.session.renderTriangleLine(0, 0x0000FF, 1, tri.v0, tri.v1, tri.v2);
        }
        
		/**
		 * @inheritDoc
		 */
        protected override function renderShader(tri:DrawTriangle):void
        {
			for each (ambient in _source.lightarray.ambients)
	    	{
				_faceVO.bitmap.draw(ambient.ambientBitmap, null, null, blendMode);
	    	}
	    	
	    	for each (directional in _source.lightarray.directionals)
	    	{
				_faceVO.bitmap.draw(directional.ambientBitmap, null, null, blendMode);
	    	}
        }
    }
}
